/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.ds;

import java.util.*;

/**
 * This class is used to hold a record (of user database zone file) from the directory server.
 */
class CustomerRecord
{
	private UserID m_ID = null;
	private String m_CustomMsg = null;

	private static final String HDR_USERID = "userid=";
	private static final String HDR_CUSTMSG = "custmsg=";
	private static final String DELIMITER = ";";
	private static final int OFFSET_HDR_USERID = HDR_USERID.length();
	private static final int OFFSET_HDR_CUSTMSG = HDR_CUSTMSG.length();

	/**
	 * Constructor for formatted entry string retrieved from the directory database
	 * @param strCustomer formatted entry string
	 */
	public CustomerRecord(String strCustomer){
		String field;
		StringTokenizer st = new StringTokenizer(strCustomer, DELIMITER);
		
		field = st.nextToken();
		m_ID = new UserID(field.substring(OFFSET_HDR_USERID));
		field = st.nextToken();
		if (field.length() <= OFFSET_HDR_CUSTMSG)
			m_CustomMsg = new String("");
		else
			m_CustomMsg = new String(field.substring(OFFSET_HDR_CUSTMSG));
	}

	/**
	 * Constructor for user id and custom message
	 * @param id UserID object
	 * @param customMsg String object
	 */
	public CustomerRecord(UserID id, String customMsg){
		m_ID = id;
		m_CustomMsg = customMsg;
	}
	
	/**
	 * Convert into formatted entry string to be stored in the directory database
	 * @return formatted entry string
	 */
	public String toString() {
		return new String(HDR_USERID + m_ID.toString() + DELIMITER + HDR_CUSTMSG + m_CustomMsg);
	}

	/**
	 * Get user id
	 * @return UserID object
	 */
	public UserID getUserID(){
		return m_ID;
	}
	
	/**
	 * Get custom message
	 * @return custom message string
	 */
	public String getCustomMsg(){
		return m_CustomMsg;
	}
}
